/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.client.config.filebrowser;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5244;
import potionstudios.byg.client.config.filebrowser.FileEntry;
import potionstudios.byg.client.config.filebrowser.KeyCommentToolTipEntry;

public class FileBrowserScreen
extends class_437 {
    public static final Function<Path, List<Path>> CONFIG_FILES = configDir -> {
        try {
            return Files.walk(configDir, new FileVisitOption[0]).filter(path -> !path.toFile().isDirectory()).sorted(Comparator.comparing(Path::toString)).collect(Collectors.toList());
        }
        catch (IOException e) {
            e.printStackTrace();
            return new ArrayList();
        }
    };
    public static Predicate<Path> RELOADS_ON_SAVE = path -> false;
    public static Consumer<Path> ON_RELOAD = path -> {};
    private final class_437 parent;
    private final Path configDir;
    private ConfigMap<?> configFiles;
    private String searchCache = "";
    private class_342 searchBox;
    private final Set<KeyCommentToolTipEntry<?>> hidden = new ObjectOpenHashSet();

    public FileBrowserScreen(class_437 parent, Path configDir, class_2561 component) {
        super(component);
        this.parent = parent;
        this.configDir = configDir;
    }

    public void method_25393() {
        this.configFiles.method_25396().forEach(KeyCommentToolTipEntry::tick);
        this.searchBox.method_1865();
    }

    protected void method_25426() {
        this.configFiles = new ConfigMap(this, this.field_22789, this.field_22790, 40, this.field_22790 - 37, 25);
        int searchWidth = 250;
        this.searchBox = new class_342(class_310.method_1551().field_1772, this.field_22789 / 2 - searchWidth / 2, 18, searchWidth, 20, (class_2561)new class_2585(""));
        this.searchBox.method_1863(this::searchResponder);
        int maxCommentWidth = this.configFiles.method_25322();
        for (Path path : CONFIG_FILES.apply(this.configDir)) {
            String relativizedPath = this.configDir.getParent().relativize(path).toString();
            FileEntry fileEntry = new FileEntry(RELOADS_ON_SAVE.test(path), this, relativizedPath, path, ON_RELOAD);
            maxCommentWidth = Math.max(maxCommentWidth, fileEntry.getRowLength());
            this.configFiles.addEntry(fileEntry);
        }
        this.configFiles.rowWidth = maxCommentWidth;
        int buttonWidth = 150;
        this.method_37063((class_364)new class_4185(this.field_22789 - this.field_22789 / 2 - buttonWidth / 2, this.field_22790 - 30, buttonWidth, 20, class_5244.field_24334, p_95761_ -> this.field_22787.method_1507(this.parent)));
        this.method_37063((class_364)this.searchBox);
        this.method_25429((class_364)this.configFiles);
        super.method_25426();
    }

    private void searchResponder(String s) {
        if (!this.searchCache.equals(s)) {
            List children = this.configFiles.method_25396();
            ArrayList keyCommentToolTipEntries = new ArrayList(children);
            for (KeyCommentToolTipEntry child : keyCommentToolTipEntries) {
                if (child.key.toLowerCase(Locale.ROOT).contains(s.toLowerCase(Locale.ROOT))) continue;
                children.remove((Object)child);
                child.renderToolTip = false;
                this.hidden.add(child);
            }
            for (KeyCommentToolTipEntry entry : new ObjectOpenHashSet(this.hidden)) {
                if (!entry.key.toLowerCase(Locale.ROOT).contains(s.toLowerCase(Locale.ROOT))) continue;
                children.add(entry);
                this.hidden.remove((Object)entry);
            }
            this.searchCache = s;
            this.configFiles.method_25307(0.0);
        }
    }

    public void method_25394(class_4587 pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        this.method_25420(pPoseStack);
        this.configFiles.method_25394(pPoseStack, pMouseX, pMouseY, pPartialTick);
        FileBrowserScreen.method_27534((class_4587)pPoseStack, (class_327)this.field_22793, (class_2561)this.field_22785, (int)(this.field_22789 / 2), (int)5, (int)0xFFFFFF);
        super.method_25394(pPoseStack, pMouseX, pMouseY, pPartialTick);
        for (KeyCommentToolTipEntry child : this.configFiles.method_25396()) {
            if (!child.renderToolTip) continue;
            this.method_32634(pPoseStack, child.toolTip, Optional.empty(), pMouseX, pMouseY);
        }
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    public static class ConfigMap<T>
    extends class_4265<KeyCommentToolTipEntry<T>> {
        private final class_437 screen;
        private int rowWidth;

        public ConfigMap(class_437 screen, int width, int height, int y0, int y1, int itemHeight) {
            super(class_310.method_1551(), width, height, y0, y1, itemHeight);
            this.screen = screen;
            this.rowWidth = super.method_25322();
            this.method_31322(false);
        }

        protected boolean method_25316() {
            return this.screen.method_25399() == this;
        }

        public int addEntry(KeyCommentToolTipEntry $$0) {
            return super.method_25321((class_350.class_351)$$0);
        }

        public int method_25322() {
            return this.rowWidth;
        }

        protected int method_25329() {
            return this.field_22742 - 10;
        }
    }
}

